;
;       ASCREEN.ASM - St ruutumoodin 3 interruptien kera
;       Vrit vakioina, mys.
;       Duke NEMO & Marq 1996
;
;       assembler-osa

.include "screen.inc"

ascreen3:
        di                              ;       Disable interrupts
        VDP_WRITE(VDP_MODE1,11101010b)  ;       Set mode 3
        VDP_WRITE(VDP_MODE0,01000000b)

        VDP_WRITE(VDP_ATTR,0>>6)        ;       Set Colour table address (0)

        VDP_WRITE(VDP_NAME,800h>>10)    ;       Set Name table address (800h)

        VDP_WRITE(VDP_CHAR,0>>11)       ;       Set pattern generator address (0)

        VDP_WRITE(VDP_SPRA,1b00h>>7)    ;       Set sprite attribute address (1B00h)

        VDP_WRITE(VDP_SPRP,3800h>>11)   ;       Set sprite pattern address (3800h)

        VDP_ADDR(800h)                  ;       Write name table at 800h
        ei
        
        ld      c,0
        ld      h,8

ASCRY:  ld      b,0
        ld      l,128

ASCRX:  ld      a,b
        and     31
        add     a,c
        inc     b
        out     (098h),a
        dec     l
        ld      a,l
        or      0
        jr      nz,ASCRX

        ld      a,c
        add     a,32
        ld      c,a
        dec     h
        ld      a,h
        or      0
        jr      nz,ASCRY

        di
        VDP_ADDR(0)             ;       Write colour table at 0
        ei

        ld      hl,1536         ;       Clear it
ASCRF:  ld      a,00h
        out     (098h),a
        dec     hl
        ld      a,l
        or      h
        jr      nz,ASCRF

        di
        VDP_WRITE(VDP_COLOR,11h) ;       Set border color to 0
        ei

        ret

.end
