#include <interrupt.h>
#include <msxlib.h>
#include "ArkosTrackerPlayer_MSX.h"

// Pics
extern char mayan[],bot1[],astro[],green[];

extern unsigned char *dang[];

// Palette
static unsigned char picpal[]={BLACK,GREEN,LIGHT_BLUE,CYAN,
                               RED,LIGHT_YELLOW,GREY,WHITE};

static unsigned char blokptn[]={   0x00,0x7e,0x7e,0x7e, 0x7e,0x7e,0x7e,0x00,
                                   0xff,0xff,0xff,0xe7, 0xe7,0xff,0xff,0xff,
                                   0xff,0x81,0x81,0x81, 0x81,0x81,0x81,0xff,
                                   0x00,0x00,0x00,0x18, 0x18,0x00,0x00,0x00 };

static unsigned char buf1[768],buf2[768],texture[24*32+1024],rantomi[768+256];

static char msx1[]={ // Approximate MSX1 palette
                0,0,0,
                3,6,3,
                4,7,4,
                3,3,6,
                4,4,7,

                6,2,2,
                4,7,7,
                7,3,3,
                7,4,4,
                6,5,2,

                6,6,3,
                1,5,1,
                6,3,6,
                6,6,6,
                7,7,7
                };

unsigned char lukaps[256*4],*lowbit,*colorcyc,*treeshold;

// Scroll image vertically
void pittaa(unsigned char *d,unsigned char *s,int offi)
{
    int n;

    s+=offi<<5;
    for(n=0;n<24;n++,d+=32,s+=32)
    {
        mem_cpy(d,s,32);
        offi++;
        if(offi==24)
            s-=32*24;
    }
}

void lukap(unsigned char *d,unsigned char *table)
{
    d;table;
    _asm

    push    hl
    push    de
    push    bc

    ld      l,4(ix)
    ld      h,5(ix)
    ld      d,7(ix)
    ld      b,#0

klonk:
    ld      e,(hl)
    ld      a,(de)
    ld      (hl),a
    inc     hl

    ld      e,(hl)
    ld      a,(de)
    ld      (hl),a
    inc     hl

    ld      e,(hl)
    ld      a,(de)
    ld      (hl),a
    inc     hl

    djnz    klonk

    pop     bc
    pop     de
    pop     hl

    _endasm;
}

// Rotate the four animation frames
void rotlowbits(unsigned char *d)
{
    lukap(d,lowbit);
}

// Rotate the four animation frames
void colorcycle(unsigned char *d)
{
    lukap(d,colorcyc);
}

void threshold(unsigned char *d)
{
    lukap(d,treeshold);
}

void suumi(unsigned char *d,unsigned char *s,unsigned off)
{
    unsigned char i,j;

    s+=off;

    for(i=0;i<12;i++)
    {
        for(j=0;j<16;j++)
        {
            *d++=*s;
            *d++=*s++;
        }

        mem_cpy(d,d-32,32);
        d+=32;
        s+=16;
    }
}

unsigned char *hlinep;
void hline(int y,unsigned char c)
{
    hlinep=&texture[y<<5];

    _asm

    push    hl
    push    bc

    ld      a,6(ix)
    ld      hl,(_hlinep)

    ld      b,#8

nakki:
    ld      (hl),a
    inc     hl
    ld      (hl),a
    inc     hl
    ld      (hl),a
    inc     hl
    ld      (hl),a
    inc     hl
    djnz    nakki

    pop     bc
    pop     hl

    _endasm;
}

unsigned char *vlinep;
void vline(int x,unsigned char c)
{
    x;c;
    vlinep=&texture[x];

    _asm

    push    hl
    push    bc

    ld      a,6(ix)
    ld      hl,(_vlinep)
    ld      bc,#32

    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc

    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc

    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc

    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc

    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc

    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc
    ld      (hl),a
    add     hl,bc

    pop     bc
    pop     hl

    _endasm;
//    for(i=0;i<24;i++,p+=32)
//        *p=c;
}

void dodang(unsigned char *d,unsigned char **ptr)
{
    d;ptr;
    _asm

    push    iy
    push    hl
    push    de
    push    bc

    ld      e,4(ix)
    ld      d,5(ix)
    ld      l,6(ix)
    ld      h,7(ix)
    push    de
    pop     iy

    ld      b,#0

lupara:
    ld      e,(hl)
    inc     hl
    ld      d,(hl)
    inc     hl
    ld      a,(de)
    ld      (iy),a
    inc     iy

    ld      e,(hl)
    inc     hl
    ld      d,(hl)
    inc     hl
    ld      a,(de)
    ld      (iy),a
    inc     iy

    ld      e,(hl)
    inc     hl
    ld      d,(hl)
    inc     hl
    ld      a,(de)
    ld      (iy),a
    inc     iy

    djnz    lupara

    pop     bc
    pop     de
    pop     hl
    pop     iy

    _endasm;
}

void or(void *d,void *s)
{
    d;s;

    _asm

    push    bc
    push    de
    push    hl

    ld      l,4(ix)
    ld      h,5(ix)
    ld      e,6(ix)
    ld      d,7(ix)
    ld      b,#0

sakki:
    ld      a,(de)
    inc     de
    ld      c,(hl)
    or      c
    ld      (hl),a
    inc     hl

    ld      a,(de)
    inc     de
    ld      c,(hl)
    or      c
    ld      (hl),a
    inc     hl

    ld      a,(de)
    inc     de
    ld      c,(hl)
    or      c
    ld      (hl),a
    inc     hl

    djnz    sakki

    pop     hl
    pop     de
    pop     bc

    _endasm;
}

void xor(void *d,void *s)
{
    d;s;

    _asm

    push    bc
    push    de
    push    hl

    ld      l,4(ix)
    ld      h,5(ix)
    ld      e,6(ix)
    ld      d,7(ix)
    ld      b,#0

jakki:
    ld      a,(de)
    inc     de
    ld      c,(hl)
    xor     c
    ld      (hl),a
    inc     hl

    ld      a,(de)
    inc     de
    ld      c,(hl)
    xor     c
    ld      (hl),a
    inc     hl

    ld      a,(de)
    inc     de
    ld      c,(hl)
    xor     c
    ld      (hl),a
    inc     hl

    djnz    jakki

    pop     hl
    pop     de
    pop     bc

    _endasm;
}

void and(void *d,void *s)
{
    d;s;

    _asm

    push    bc
    push    de
    push    hl

    ld      l,4(ix)
    ld      h,5(ix)
    ld      e,6(ix)
    ld      d,7(ix)
    ld      b,#0

fakki:
    ld      a,(de)
    inc     de
    ld      c,(hl)
    and      c
    ld      (hl),a
    inc     hl

    ld      a,(de)
    inc     de
    ld      c,(hl)
    and      c
    ld      (hl),a
    inc     hl

    ld      a,(de)
    inc     de
    ld      c,(hl)
    and      c
    ld      (hl),a
    inc     hl

    djnz    fakki

    pop     hl
    pop     de
    pop     bc

    _endasm;
}

static volatile char mus_fftargetpart = 0; // fast forward target part
static volatile char mus_ffingtopart = 0; // are we fast forwarding to a part

static volatile char mus_tick = 0; // vbi num
static volatile char mus_beat = 0; // musical beat
static volatile char mus_part = 0; // total part number
static char timestocall = 1; // how many times to call the playroutine
static volatile int totalframes = 0;

void my_isr(void) interrupt { /* THE INTERRUPT */
    DI;
    READ_VDP_STATUS;

    totalframes++;
    
    if (mus_fftargetpart > mus_part) timestocall = 16;
    else if (ispressed(K_7)) { if (mus_part < 7) mus_fftargetpart = 7; timestocall = 1; mus_ffingtopart = 1; }
    else if (ispressed(K_0)) { if (mus_part < 10) mus_fftargetpart = 10; timestocall = 1; mus_ffingtopart = 1; }
    else if (ispressed(K_TAB)) { mus_fftargetpart = mus_part + 1; timestocall = 1; mus_ffingtopart = 1; }
    else if (ispressed(K_S)) timestocall=2; 
    else if (ispressed(K_D)) timestocall=4;         
    else if (ispressed(K_F)) timestocall=6;     
    else timestocall=1;
    
    while (timestocall--)
    {
      PLY_Play();
        
        mus_tick ++;
        switch (mus_part)
        {
            case 0: // rowtempo 6, ** robot's engine is starting up **
                if (mus_tick >= 24) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 8+12) { mus_part++; mus_beat = 0; }
                break;
                
            case 1: // rowtempo 6, ** robot's engine is running **
                if (mus_tick >= 24) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 20) { mus_part++; mus_beat = 0; }
                break;
                
            case 2: // rowtempo 4+4+3+3, 14 ticks ber beat, ** music!! **
                if (mus_tick >= 14) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 16*2) { mus_part++; mus_beat = 0; }
                break;
                
            case 3: // rowtempo 4+4+3+3, 14 ticks ber beat, KOMPPI KAY
                if (mus_tick >= 14) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 16*4) { mus_part++; mus_beat = 0; }
                break;
                
            case 4: // melody
                if (mus_tick >= 14) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 16*3) { mus_part++; mus_beat = 0; }
                break;
                
            case 5: // komppi
                if (mus_tick >= 14) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 16*2) { mus_part++; mus_beat = 0; }
                break;
                
            case 6: // PIIIIIIIIIIP
                if (mus_tick >= 8) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 32) { mus_part++; mus_beat = 0; }
                break;
                
            case 7: // Melody 2
                if (mus_tick >= 14) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 16*5) { mus_part++; mus_beat = 0; }
                break;
                
            case 8: // komppi
                if (mus_tick >= 14) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 16*2) { mus_part++; mus_beat = 0; }
                break;
                
            case 9: // loppukomppi alkaa
                if (mus_tick >= 14) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 16*2) { mus_part++; mus_beat = 0; }
                break;
                
            case 10: //
                if (mus_tick >= 14) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 16*4) { mus_part++; mus_beat = 0; }
                break;
                
            case 11: // iso loppukomppi
                if (mus_tick >= 14) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 28) { mus_part++; mus_beat = 0; }
                break;
                
            case 12: // loppuuuu
                if (mus_tick >= 14) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 4) { mus_part++; mus_beat = 0; }
                break;
                
            case 13: // robot shuts down
                if (mus_tick >= 14) { mus_beat++; mus_tick = 0; }
                if (mus_beat >= 4) { mus_part++; mus_beat = 0; }
                break;
                
                // when mus_part = 14, demo ENDS, end bleep sound, robot has been shut down 
            default: break; 
        } // switch
        if ((mus_ffingtopart) && (mus_part >= mus_fftargetpart))
        {
            mus_ffingtopart = 0;
            timestocall = 0;
        }
    } // while timestocall
    PLY_SendRegisters();
    EI;
}

void main(void)
{
    int i=0,j,k,l,
        suum=0,ohvi=0,plusa=33,swirl=0,circles=0;
    unsigned char c,sum,*p,*s,*d;
    unsigned u;

    spindown();
    screen(2);

    PLY_SongPtr = (char *)0x0103;
    PLY_Init();

    // Blank
    vdp_register(VDP_COLOR,BLACK);
    vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM);

    if(isvdp2())
    {
        for(i=0;i<15;i++)
            msx2_palette(i+1,msx1[i*3+0],msx1[i*3+1],msx1[i*3+2]);
    }

    // Calc lookups
    u=(((unsigned)lukaps)+255)&0xff00;
    lowbit=(unsigned char *)u;
    colorcyc=(unsigned char *)(u+256);
    treeshold=(unsigned char *)(u+512);

    for(i=0;i<256;i++)
    {
        lowbit[i]=(i&0xfc)+(i+1&3);

        colorcyc[i]=(i&0x1f)+(i+0x20&0xe0);
        colorcyc[i]=(colorcyc[i]&0xe3)+(i+4&0x1c);

        sum=0;
        c=i>>5;
        switch(c)
        {
            case 0: sum+=0; break;
            case 1: sum+=4; break;
            case 2: sum+=5; break;
            case 3: sum+=7; break;
            case 4: sum+=3; break;
            case 5: sum+=7; break;
            case 6: sum+=6; break;
            case 7: sum+=8; break;
        }
        c=(i>>2)&7;
        switch(c)
        {
            case 0: sum+=0; break;
            case 1: sum+=4; break;
            case 2: sum+=5; break;
            case 3: sum+=7; break;
            case 4: sum+=3; break;
            case 5: sum+=7; break;
            case 6: sum+=6; break;
            case 7: sum+=8; break;
        }

        if(sum>9)
            treeshold[i]=0xdc+(i&3);
        else
            treeshold[i]=0x18+(i&3);
    }

    for(i=0;i<32*24;i++)
    {
        texture[i]=0;
        dang[i]+=(unsigned)texture;
    }

    for(i=0;i<768+256;i++)
    {
        rantomi[i]=(i+random()+random())&3;
    }

    // Set up color table o.O
    DI;
    for(i=0;i<64;i++)
    {
        c=picpal[i>>3]+(picpal[i&7]<<4);
        for(j=0;j<32;j++)
        {
            vdp_poke(COLOR_TABLE+(i<<5)+j,c);
            vdp_poke(COLOR_TABLE+2048+(i<<5)+j,c);
            vdp_poke(COLOR_TABLE+4096+(i<<5)+j,c);
        }
    }
    EI;

    // Och pattern table x.X
    DI;
    for(i=0;i<4;i++)
    {
        p=&blokptn[i<<3];
        for(j=0;j<2048;j+=32)
        {
            vdp_address(PATTERN_TABLE+(i<<3)+j);
            vdp_copy(p,8);
            vdp_address(PATTERN_TABLE+2048+(i<<3)+j);
            vdp_copy(p,8);
            vdp_address(PATTERN_TABLE+4096+(i<<3)+j);
            vdp_copy(p,8);
        }
    }
    EI;

    // Black & unblank
    waitVB();
    vdp_set(0,768);
    vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM+MODE1_BLANK);
    vdp_address(NAME_TABLE);

    mem_set(buf1,0,768);
    d=buf1;

    // soitto soi
    install_isr(my_isr);

    // Main loop
    i=j=k=l=0;
    j=-1;
    while(!space() && (mus_part < 14))
    {
        // Part 0: Random growing
        if(mus_part==0)
        {
            j++;
            if(j>20)
            {
                j=0;
                p=&rantomi[random()&255];
                s=buf1;
                for(i=0;i<768;i++,p++)
                    *s+++=*p&1;
            }

            d=buf1;
            //rotlowbits(d);
        }

        // Part 1: Alternating zoomer
        if(mus_part==1)
        {
            suum++;
            if(!(suum&8) && (mus_beat < 4))
            {
                pittaa(buf1,bot1,0);
                j=(random()&3<<5)+(random()&3)+6;
            }
            else
            {
                if (mus_beat >= 16)
                    pittaa(buf1,bot1,(mus_tick & 8)>>3);
                else if (mus_beat >= 12)
                    pittaa(buf1,bot1,(mus_tick & 4)>>2);
                else if (mus_beat >= 8)
                    pittaa(buf1,bot1,(mus_tick & 2)>>1);
                else if (mus_beat >= 4)
                    suumi(buf1,bot1,j + ((mus_tick & 2) >> 1) + (mus_beat & 1));
                else
                    suumi(buf1,bot1,j);
            }
            d=buf1;
        }

        // Part 2: Burning (Myrskyluodon) Maya
        if(mus_part==2)
        {
            mem_cpy(buf1,mayan,768);
            p=&rantomi[random()&255];
            if (mus_beat < 16)
            {
                for(i=0;i<768;i++)
                {
                    buf1[i]=(*p++)<<2;
                }
            }
            else
            {
                for(i=0;i<768;i++)
                {
                    buf1[i]+=*p++;
                }
            }
            d=buf1;
        }

        // Part 3: Radar-like
        if(mus_part==3)
        {
            for(k=0;k<32;k+=8)
            {
                if(mus_beat > 32)
                    l=(swirl-k)&31;
                else 
                    l=(swirl+k)&31;

                if((k&8))
                {
                    vline((l+1)&31,0x1c + (mus_beat&&3));
                    vline(l,0xf8);
                }
                else
                {
                    vline((l+1)&31,0x1c);
                    vline(l,0);
                }
            }

            dodang(buf1,dang);
            xor(buf1,mayan);
            d=buf1;
            if (mus_beat < 32)
                swirl++;
            else
                swirl+= 1 + ((mus_beat&2));
            if(swirl>=32)
                swirl=0;
        }

        // Colorcycle
        if(mus_part==4)
        {
            waitVB();
            waitVB();
            d=green;
            if((mus_beat&2)==0)
                colorcycle(d);
            else
                rotlowbits(d);
        }

        // Threshold
        if(mus_part==5)
        {
            pittaa(buf1,astro,0);
            d=buf1;
            if(mus_beat&1)
            {
                if(totalframes&2)
                    threshold(d);
            }
            else
                rotlowbits(astro);

            if(mus_beat&8)
            {
                suumi(buf2,d,32*2+9);
                d=buf2;
            }
        }

        // Random "bug" copy PART 6 = PIIIIIIIIIIIP
        if(mus_part==6)
        {
            waitVB();
            pittaa(buf1,bot1,random()%24);
            d=buf1;
        }

        // Circles
        if(mus_part==7)
        {
            hline((circles+9)%24,0x1c);
            hline((circles+8),0xf8);
            hline((circles+1)%24,0x1c);
            hline(circles,0);

            if(mus_beat<32 || mus_beat>=48)
                pittaa(buf2,bot1,random()%24);
            else
                pittaa(buf2,bot1,0);
            dodang(buf1,dang);

            if((mus_beat&1)==0)
                circles++;
            if(circles>=24)
                circles=0;

            if((random()&7)==0)
                xor(buf1,buf2);
            else
                or(buf1,buf2);

            d=buf1;
        }

        // Circles
        if(mus_part==8)
        {
            hline((circles+9)%24,0x1c);
            hline((circles+8),0xf8);
            hline((circles+1)%24,0x1c);
            hline(circles,0);

            circles++;
            if(circles>=24)
                circles=0;

            dodang(buf1,dang);

            if(mus_beat%5)
                and(buf1,bot1);
            else
                or(buf1,bot1);

            d=buf1;
        }

        // Part 9: Radar-like
        if(mus_part==9)
        {
            for(k=0;k<32;k+=8)
            {
                if(mus_beat > 32)
                    l=(swirl-k)&31;
                else
                    l=(swirl+k)&31;

                if((k&8))
                {
                    vline((l+1)&31,0x1c + (mus_beat&&3));
                    vline(l,0xf8);
                }
                else
                {
                    vline((l+1)&31,0x1c);
                    vline(l,0);
                }
            }

            dodang(buf1,dang);
            xor(buf1,astro);
            d=buf1;
            if (mus_beat < 32)
                swirl++;
            else
                swirl+= 1 + ((mus_beat&2));
            if(swirl>=32)
                swirl=0;
        }

        // Zoomrotate images
        if(mus_part==10)
        {
            ohvi+=plusa;

            if(mus_beat&4)
            {
                if((mus_beat&2)==0)
                    plusa=33;
                else
                    plusa=-33;
            }
            else
            {
                if((mus_beat&2)==0)
                    plusa=36;
                else
                    plusa=-35;
            }

            mem_cpy(texture,&mayan[ohvi],32*24);
            dodang(buf1,dang);
            d=buf1;
        }

        // 11: Destroy maya
        if(mus_part==11)
        {
            waitVB();
            waitVB();
            if((random()&3)==0)
            {
                pittaa(buf1,mayan,0);

                p=&rantomi[random()&255];
                s=buf1;
                for(i=0;i<768;i++,p++)
                    *s+++=*p+(i&4);
                d=buf1;
            }
            else
            {
                rotlowbits(mayan);
                d=mayan;
            }
            j=20;
        }

        // Part 12: Robot shuts down
        if(mus_part==12)
        {
            j++;
            if(j>20)
            {
                j=0;
                p=&rantomi[random()&255];
                s=buf1;
                for(i=0;i<768;i++,p++)
                    *s+++=*p&1;
            }
            d=buf1;
            rotlowbits(d);
        }

        // Alternating zoomer
        if(mus_part==13)
        {
            suum++;
            if(!(suum&8))
            {
                pittaa(buf1,bot1,0);
                j=(random()&3<<5)+(random()&3)+6;
            }
            else
            {

                suumi(buf1,bot1,j);
            }
            d=buf1;
        }

        waitVB();
        vdp_address(NAME_TABLE);
        vdp_copy(d,768);
    }

    suumi(buf1,bot1,64+3+6+2);
    waitVB();
    vdp_address(NAME_TABLE);
    vdp_copy(d,768);
    
    for(i=0;i<50*1;i++)
        waitVB();

    uninstall_isr();
    PLY_Stop();

    for(i=0;i<50*2;i++)
      waitVB();

    screen(0);
}
