// LT2S 1.2 by Marq/L!T
// Use as you see fit
// Needs to be compiled with SDCC 2.8.0

#include <interrupt.h>
#include <ioport.h>
#include "msxlib.h"

#define MAXCOPY 2048 // Longest possible copy
#define MAXDATA (76+2*(768+6144+6144)) // Maximum size of img file
#define BLANKTIME 1400

#define waitVB() juuh=0;while(juuh==0);

#define VDPADDR(draw,n,add) \
        draw[n++]=0x3e; \
        draw[n++]=(add)&0xff; \
        draw[n++]=0xd3; \
        draw[n++]=0x99; \
        draw[n++]=0x3e; \
        draw[n++]=((add)>>8)+0x40; \
        draw[n++]=0xd3; \
        draw[n++]=0x99;

#define SRCADDR(draw,n,src) \
        draw[n++]=0x21; \
        draw[n++]=((unsigned)(src))&0xff; \
        draw[n++]=((unsigned)(src))>>8;

#define FASTCOPY(draw,n,bytez) \
        draw[n++]=0xcd; \
        cad=(unsigned)&outi[(MAXCOPY-(bytez))*2]; \
        draw[n++]=cad&0xff; \
        draw[n++]=cad>>8;

#define SLOWCOPY(draw,n,bytez) \
        draw[n++]=0xcd; \
        cad=(unsigned)&outinop[(MAXCOPY-(bytez))*4]; \
        draw[n++]=cad&0xff; \
        draw[n++]=cad>>8;

void callist(void *p)
{
        p;
        _asm
        push    bc

        ld      bc,#BAKKIS
        push    bc
        ld      c,4(ix)
        ld      b,5(ix)
        push    bc
        ld      c,#0x98
        ret

BAKKIS:
        pop     bc
        _endasm;
}

volatile unsigned char juuh=0;

sfr at 0x99 vdp2;
void my_isr(void) interrupt __naked
{
	_asm
	push	af
	in	a,(0x99)
	ld	a,(_juuh)
	inc	a
	ld	(_juuh),a
	pop	af
	ei
	reti
	_endasm;
}

int main(char **argv,int argc)
{
	int	page,slice,i,slow;
	unsigned char raster=0;
	static unsigned char data[MAXDATA];
	static unsigned char draw1[128],draw2[128];
	static unsigned char outi[MAXCOPY*2+1],outinop[MAXCOPY*4+1],
                             *draw;
	unsigned *ofs=(unsigned *)data,cad,cplus,seepu,n;

	if(readfile(argv[0],data))
		return(1);
	spindown();

	screen(2);

	vdp_register(VDP_COLOR,BLACK);

	// Generate copy tables
        for(n=0;n<MAXCOPY*2;n+=2)
        {
                outi[n]=0xed; // OUTI
                outi[n+1]=0xa3;
        }
        outi[MAXCOPY*2]=0xc9; // RET
        for(n=0;n<MAXCOPY*4;n+=4)
        {
                outinop[n]=0xed; // OUTI
                outinop[n+1]=0xa3;
                outinop[n+2]=0; // NOP
                outinop[n+3]=0;
        }
        outinop[MAXCOPY*4]=0xc9; // RET

	install_isr(my_isr);

	// Name tables
	waitVB();
	vdp_address(0x1800);
	vdp_copy(&data[ofs[36]],768);
	waitVB();
	vdp_address(0x3800);
	vdp_copy(&data[ofs[37]],768);

	// Static colors and patterns
	for(n=0;n<3;n++)
	{
		waitVB();
		vdp_address(n*2048);
		vdp_slowcopy(&data[ofs[n*6]],ofs[n*6+1]);
		waitVB();
		vdp_address(0x2000+n*2048);
		vdp_slowcopy(&data[ofs[18+n*6]],ofs[18+n*6+1]);
	}

	// Generate code that calls the OUTI tables
	for(page=0;page<2;page++)
	{
		n=seepu=slow=0;
		if(!page)
			draw=draw1;
		else
			draw=draw2;
		for(i=0;i<3;i++)
		{	
			slice=i;
			cplus=ofs[page*2+slice*6+3];
			if(cplus)
			{
			    VDPADDR(draw,n,slice*2048+ofs[slice*6+1]); // Pattern
			    SRCADDR(draw,n,&data[ofs[page*2+slice*6+2]]);
			    if(!slow) // Blank over?
			    {
				if(cplus+seepu>BLANKTIME)
				{
					FASTCOPY(draw,n,BLANKTIME-seepu);
					SLOWCOPY(draw,n,cplus+seepu-BLANKTIME);
					slow=1;
				}
				else
				{
					FASTCOPY(draw,n,cplus);
				}
			    }
			    else
			    {
				SLOWCOPY(draw,n,cplus);
			    }
			}
			seepu+=cplus;

			cplus=ofs[page*2+slice*6+21];
			if(cplus)
			{
			    VDPADDR(draw,n,0x2000+slice*2048+ofs[slice*6+19]); // Color
			    SRCADDR(draw,n,&data[ofs[page*2+slice*6+20]]);
			    if(!slow) // Blank over?
			    {
				if(cplus+seepu>BLANKTIME)
				{
					FASTCOPY(draw,n,BLANKTIME-seepu);
					SLOWCOPY(draw,n,cplus+seepu-BLANKTIME);
					slow=1;
				}
				else
				{
					FASTCOPY(draw,n,cplus);
				}
			   }
			   else
			   {
				SLOWCOPY(draw,n,cplus);
			   }
			}

			seepu+=cplus;
		}
		draw[n]=0xc9; // RET
	}

	// Main loop
	while(!ispressed(K_ESC))
	{
		waitVB();
		if(raster) vdp_register(VDP_COLOR,DARK_RED);
		vdp_register(VDP_NAME_T,0x6);
		callist(draw1);
		if(raster) vdp_register(VDP_COLOR,BLACK);

		if(space())
			raster=1;
		else
			raster=0;

		waitVB();
		if(raster) vdp_register(VDP_COLOR,DARK_BLUE);
		vdp_register(VDP_NAME_T,0xe);
		callist(draw2);
		if(raster) vdp_register(VDP_COLOR,BLACK);
	}
	
	uninstall_isr();
	
	screen(0);
        return(0);
}
