
; MYMPLAY - Player for MYM-tunes
; MSX-version by Marq/Lieves!Tuore & Fit 30.1.2000
;
; 1.2.2000  - Added the disk loader. Thanks to Yzi & Plaque for examples.
;
; Source suitable for Table-driven assembler (TASM), sorry all
; Devpac freaks v/
;
;
; 2/2/2000 - Zack <dom@jb.man.ac.uk>
;
;       ZX Spectrum + AY Port
;       Converted over to z80asm format cos za80 was being awkward
;
; Notes:
;       ZX Version uses im2 (can't capture unlike on MSX)
;       AY Ports on ZX are $BFFD - port select
;                          $FFFD - data write
;
;       Tune length is limited to ~26350 bytes (Not sure if we'd be 
;       affected by contention if we locate at 24576 - working on emu!)
;       If not affected than can have ~34540 bytes
;
; 7/2/2000 - Zack <dom@jb.man.ac.uk>
;       ZX Port of MSX v0.4


        defc FRAG    =    128     ; Fragment size
        defc REGS    =    14      ; Number of PSG registers
        defc FBITS   =    7       ; Bits needed to store fragment offset
        defc table   =   65024    ; Where we put our im2 int table
        defc intjp   =   65021    ; Ye olde im2 jump


        MODULE  psg

        
        org     24576           ; or 32768

        exx                     ; Starting values for procedure readbits
        ld      e,1
        ld      d,0
        ld      hl,rows+2
        exx

        ld      hl,uncomp+FRAG       ; Starting values for the playing variables
        ld      (dest1),hl
        ld      (dest2),hl
        ld      (psource),hl
        ld      a,FRAG
        ld      (played),a
        ld      hl,0
        ld      (prows),hl

        call    extract         ; Unpack the first fragment

        call    setint          ; Set up the interrupts

.mainloop
        call    extract

.waitvb
        ld      a,(played)      ; Wait until VBI has played a fragment
        or      a
        jr      nz,waitvb
        ld      (psource),iy
        ld      a,FRAG
        ld      (played),a
        call    keypress
        jr      z,mainloop

        call    shutint
        call    shutup

        ret                     ; Goodbye!

; *** Unpack a fragment. Returns IY=new playing position for VBI
.extract
        xor     a
.regloop
        push    af
        ld      c,a
        ld      b,0
        ld      hl,regbits      ; D=Bits in this PSG register
        add     hl,bc
        ld      d,(hl)
        ld      hl,current      ; E=Current value of a PSG register
        add     hl,bc
        ld      e,(hl)

        ld      bc,FRAG*3       ; v0.4
        ld      hl,(dest1)      ; IX=Destination 1
        ld      ix,(dest1)
        add     hl,bc
        ld      (dest1),hl
        ld      hl,(dest2)      ; HL=Destination 2
        push    hl
        add     hl,bc
        ld      (dest2),hl
        pop     hl

        ex      af,af'
        ld      a,FRAG          ; AF'=fragment end counter
        ex      af,af'
        ld      a,1             ; Get fragment bit
        call    readbits
        or      a
        jr      nz,compfrag     ; 1=Compressed fragment, 0=Unchanged

        ld      b,FRAG          ; Unchanged fragment just set all to E
.sweep  ld      (hl),e
        inc     hl
        ld      (ix+0),e
        inc     ix
        djnz    sweep
        jp      nextreg

.compfrag                       ; Compressed fragment
        ld      a,1
        call    readbits
        or      a
        jr      nz,notprev      ; 0=Previous register value, 1=raw/compressed

        ld      (hl),e          ; Unchanged register
        inc     hl
        ld      (ix+0),e
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        jp      nextbit

.notprev
        ld      a,1
        call    readbits
        or      a
        jr      z,packed        ; 0=compressed data  1=raw data

        ld      a,d             ; Raw data, read regbits[i] bits
        call    readbits
        ld      e,a
        ld      (hl),a
        inc     hl
        ld      (ix+0),a
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        jp      nextbit

.packed ld      a,FBITS         ; Reference to previous data
        call    readbits        ; Read the offset
        ld      c,a
        ld      a,FBITS         ; Read the number of bytes
        call    readbits
        ld      b,a

        push    hl
        push    bc
        ld      bc,-FRAG
        add     hl,bc
        pop     bc
        ld      a,b
        ld      b,0
        add     hl,bc
        ld      b,a
        push    hl
        pop     iy              ; IY=source address
        pop     hl

        inc     b
.copy   ld      a,(iy+0)          ; Copy from previous data 
        inc     iy
        ld      e,a             ; Set current value
        ld      (hl),a
        inc     hl
        ld      (ix+0),a
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        djnz    copy

.nextbit
        ex      af,af'          ; If AF'=0 then fragment is done
        ld      c,a
        ex      af,af'
        ld      a,c
        or      a
        jp      nz,compfrag

.nextreg
        pop     af
        ld      b,0             ; Save the current value of PSG reg
        ld      c,a
        push    hl
        ld      hl,current
        add     hl,bc
        ld      (hl),e
        pop     hl

        inc     a               ; Check if all registers are done
        cp      REGS
        jp      nz,regloop

        or      a               ; Check if dest2 must be wrapped
        ld      bc,rows
        sbc     hl,bc
        jr      nz,nowrap

        ld      ix,uncomp+FRAG
        ld      hl,uncomp+FRAG
        ld      iy,uncomp+(2*FRAG)
        jr      endext

.nowrap ld      ix,uncomp
        ld      hl,uncomp+(2*FRAG)
        ld      iy,uncomp+FRAG

.endext ld      (dest1),ix
        ld      (dest2),hl

        ld      bc,FRAG
        ld      hl,(prows)
        add     hl,bc
        ld      (prows),hl
        ld      bc,(rows)
        or      a
        sbc     hl,bc
        jr      c,noend         ; If rows>played rows then exit
        exx                     ; Otherwise restart
        ld      e,1
        ld      d,0
        ld      hl,rows+2
        exx
        ld      hl,0
        ld      (prows),hl

.noend  ret

; *** Reads A bits from data, returns bits in A
.readbits
        exx
        ld      b,a
        ld      c,0

.onebit sla     c               ; Get one bit at a time
        rrc     e
        jr      nc,nonew        ; Wrap the AND value
        ld      d,(hl)
        inc     hl

.nonew  ld      a,e
        and     d
        jr      z,zero
        inc     c
.zero   djnz    onebit

        ld      a,c
        exx
        ret

; *** The interrupt handler. Partially MSX specific
.interrupt
        push    af
        push    bc
        push    de
        push    hl


        ld      hl,(psource)
        ld      de,-1+(3*FRAG)   ; Bytes to skip before next reg-1
        xor     a
        ld      c,253
.ploop  ld      b,255
        out     (c),a
        ld      b,191
        outi
        inc     a
        add     hl,de
        cp      REGS-1
        jp      nz,ploop

        ld      a,(hl)
        inc     a       ;if reg 13=255 skip
        jr      z,notrig
        ld      a,13
        ld      bc,65533
        out     (c),a
        ld      b,191
        outi

.notrig ld      hl,(psource)
        inc     hl
        ld      (psource),hl

        ld      a,(played)
        or      a
        jr      z,endint
        dec     a
        ld      (played),a

.endint pop     hl
        pop     de
        pop     bc
        pop     af
        ei
        ret

;
; Sets up the im2 table and switches mode
;
.setint
        di
        ld      hl,table
        ld      de,table+1
        ld      bc,256
        ld      (hl),253
        ldir
        ld      a,195
        ld      (intjp),a
        ld      hl,interrupt
        ld      (intjp+1),hl
        ld      a,254
        ld      i,a
        im      2
        ei
        ret

;
; Turn off the interrupts, go back to im 1 (default for ZX)
; Restore hl' so BASIC stays sane
;

.shutint
        di
        ld      a,63
        ld      i,a
        im      1
        ld      hl,10072
        exx
        ei
        ret





; *** Returns Z=1 if key pressed. ZX-specific
.keypress
        xor     a
        in      a,(254)
        cpl
        and     31
        ret

; *** Shuts down the audio. ZX-Specifc
.shutup
        ld      e,14
        xor     a
        ld      c,253
        ld      d,0
.shloop
        ld      b,253
        out     (c),a
        inc     a
        ld      b,191
        out     (c),d
        dec     e
        jr      nz,shloop
        ret

; *** Program data
.played defb     0       ; VBI counter
.dest1  defw     0       ; Uncompress destination 1
.dest2  defw     0       ; - " -                  2
.psource defw    0       ; Playing offset for the VB-player
.prows  defw     0       ; Rows played so far

; Bits per PSG register
.regbits defb    8,4,8,4,8,4,5,8,5,5,5,8,8,8
; Current values of PSG registers
.current defb    0,0,0,0,0,0,0,0,0,0,0,0,0,0

; Reserve room for uncompressed data 
.uncomp
        defs    (3*FRAG*REGS)
; Tune is loaded to this address
.rows

