#!/usr/bin/perl -w

#
# Simple Voting System
# index.cgi - Counts the votes and verifies the password
#
# 0.1   Markku Reunanen         26.11.1999
# 0.2   Markku Reunanen         27.11.1999
# - More specific error messages
# - Some real functionality
# 0.3	Markku Reunanen		28.11.1999
# - Checks the overlapping votes
# - Writes svs.votes and creates it if necessary
#

require 'perl/error.pl';
require 'perl/config.pl';
require 'perl/password.pl';

use constant LOCK_RETRIES => 20;  # How many retries if database is locked

# These arrays hold the information about all compos
$bg_color = "white";    # Color for default messages
$fg_color = "black";    # - " -
$compos = 0;            # Number of compos
$points = "";		# Point information
@compo_info = ();       # Information about compos

# Try to get the configuration
unless(conf_get($compos, $points, \@compo_info, $fg_color, $bg_color))
{
	error_message(ERROR_CONFIG(), $fg_color, $bg_color);
	exit 0;
}

# Let's read in the data sent us via the HTML-form
$_ = <STDIN>;

# Split the data to variable=value rows
@formdata = split(/&/);

@votes = ();
# Go through the rows and extract data
foreach $_ (@formdata)
{
	# Separate variable and its value
	($variable, $value) = split(/=/);

	# Username found
	if($variable eq "username")
	{
		$username = $value;
	}

	# Password found
	if($variable eq "password")
	{
		$password = $value;
	}

	# Compo vote found. Push "compo place entry" into votes.
	if($variable =~ /compo/)
	{
		s/(compo)|(=)/ /g;
		push(@votes, $_);
	}
}

# First authenticate the user
unless(password_check($username,$password))
{
	error_message(ERROR_AUTH(), $fg_color, $bg_color);
	exit 0;
}

# Try to lock the database
for($n = 0 ; $n < LOCK_RETRIES() ; $n++)
{
	# If we can obtain the lock let's go on
	if(mkdir("svs.lock", 0))
	{
		$n = LOCK_RETRIES() +1;
	}
	else # Otherwise wait a second
	{
		sleep 1;
	}
}

# If we didn't get the lock, exit with lock error message
if($n == LOCK_RETRIES)
{
	error_message(ERROR_LOCK(), $fg_color, $bg_color);
	exit 0;
}

# Read the votes if votefile found
@votelines = ();
if(open(VOTEFILE, "svs.votes"))
{
	@votelines = <VOTEFILE>;
	close(VOTEFILE);
}

# Go through the votelines and separate user's votes from the others
@others = ();
@user = ();
foreach $_ (@votelines)
{
	# Remove trailing newlines
	s/\n$//;

	# Collect user's votes to @user
	if(/$username/)
	{
		s/$username://;
		push(@user, $_);
	}
	else # Put others' votes to another array
	{
		push(@others, $_);
	}
}

# Update the votes
for($n = 0, $last = $#user ; $n <= $last ; $n++)
{
	# Split the current vote into compo, place and entry number
	$current = $user[$n];
	($cur_compo, $cur_place, $cur_num) = split(/ /, $current);
	
	# Check if any new vote replaces the current
	for($i = 0 ; $i <= $#votes ; $i++)
	{
		# Split the line to compo, place and entry number
		$_ = $votes[$i];
		($new_compo, $new_place, $new_num) = split(/ /);

		# Replace the old vote
		if($cur_compo == $new_compo && $cur_place == $new_place)
		{
			# If the vote has changed update it
			if($new_num)
			{
				$user[$n] = $_;
			}
			$votes[$i] = "0 0 0"; # Mark new vote as used
		}
	}
}

# If there's a new compo, add the new votes to user's votes
foreach $_ (@votes)
{
	# Add unused votes to the list
	if($_ ne "0 0 0")
	{
		push(@user, $_);
	}
}

# Check the double votes. A slow O(n^2) algorithm, but meets the needs...
for($n = 0 ; $n <= $#user ; $n++)
{
	$_ = $user[$n];
	# Split the line to compo, place and etry number
	($cur_compo, $cur_place, $cur_num) = split(/ /);

	# Compare to all other votes
	for($i = 0 ; $i <= $#user ; $i++)
	{
		$_ = $user[$i];
		($cmp_compo, $cmp_place, $cmp_num) = split(/ /);

		# We don't allow multiple votes for the same entry.
		if($cur_compo == $cmp_compo && 
                   $cur_num == $cmp_num &&
		   $n != $i && $cur_num)
		{
			rmdir("svs.lock");
			error_message(ERROR_SAME(), $fg_color, $bg_color);
			exit 0;
		}
	}
}

# Open the votefile for writing
unless(open(VOTEFILE, ">svs.votes"))
{
	rmdir("svs.lock");
	error_message(ERROR_FILE(), $fg_color, $bg_color);	
	exit 0;
}

# Write the other users' and user's votes to the votefile
foreach $_ (@others)
{
	print VOTEFILE "$_\n";
}
foreach $_ (@user)
{
	print VOTEFILE "$username:$_\n";
}
close(VOTEFILE);

# Everything went fine, remove lock, output OK and quit
rmdir("svs.lock");
error_message(ERROR_OK(),$fg_color,$bg_color);
exit 1;

# EOS
