#
# Simple Voting System
# error.pl - prints out the error messages
#
# 0.1   Markku Reunanen         26.11.1999
# 0.2   Markku Reunanen         27.11.1999
# - Added more error options
# 0.3	Markku Reunanen		28.11.1999
# - Removed ERROR_INTERNAL, we must do better than that!
#

# Error number constants
use constant ERROR_OK => 	0;
use constant ERROR_AUTH => 	1;
use constant ERROR_SAME => 	2;
use constant ERROR_LOCK => 	3;
use constant ERROR_CONFIG => 	4;
use constant ERROR_FILE =>	5;

# Prints an error message or the corresponding HTML file
# $_[0] = Error number
# $_[1] = Foreground color
# $_[2] = Background color
sub error_message
{			
	my %error_files = (ERROR_OK, 	"svs.ok.html",
			   ERROR_AUTH, 	"error.auth.html",
			   ERROR_LOCK, 	"error.lock.html",
  			   ERROR_CONFIG,"error.config.html",
			   ERROR_FILE, 	"error.file.html",
			   ERROR_SAME, 	"error.same.html");

	my %error_texts = (ERROR_OK,	"Your votes were registered ok.",
			   ERROR_AUTH,	"Invalid password.",
			   ERROR_LOCK,	"The database is busy. Try again later.",
			   ERROR_CONFIG,"SVS configuration error.",
			   ERROR_FILE,	"File error.",
			   ERROR_SAME,	"Overlapping votes.");

	# Content-type
	print "Content-type: text/html\n\n";

	# Print messages/error.*.html if found
	if(open(ERRFILE, "html/".$error_files{$_[0]}))
	{
		@html = <ERRFILE>;
		close(ERRFILE);
		print @html;
	}
	else # Else print the corresponding error message as HTML
	{
		print " <html>
			<title>SVS message</title>
			<body text=$_[1] bgcolor=$_[2]>
			$error_texts{$_[0]}<br>
			<a href=index.cgi>Reload the main page</a>
			</body></html>
		      \n";
	}
}

1;

# EOS
