#
# Simple Voting System
# password.pl - authenticates the user
# Currently can only use the old /etc/passwd system
#
# 0.1   Markku Reunanen         26.11.1999
#

# Checks the username and password
# $_[0] = Username
# $_[1] = Password
# Returns 1 on success, 0 on error
sub password_check
{
	my $pass;
	
	# Do not allow empty password or username
	unless($_[0] && $_[1])
	{
		return 0;
	}

	# Try to get the password by username
	unless($pass = (getpwnam($_[0]))[1])
	{
		# Username not known
		return 0;
	}

	# Check the password
	if(crypt($_[1], $pass) ne $pass)
	{
		0; # Wrong password
	}
	else
	{
		1; # Authentication succesful
	}
}

1;

# EOS
